<?php

namespace WTS_EAE\Modules\Timeline\Skins;

use Elementor\Widget_Base;


class Skin_4 extends Skin_Base {

	protected function _register_controls_actions() {
		parent::_register_controls_actions(); // TODO: Change the autogenerated stub
		add_action( 'elementor/element/eae-timeline/skin4_icon_global_style/after_section_end', [ $this, 'extra_control' ] );
		add_action( 'elementor/element/eae-timeline/skin4_section_global_icon/after_section_end', [ $this, 'update_icon_control' ] );
	}

	public function get_id() {
		return 'skin4';
	}

	public function get_title() {
		return __( 'Skin 4', 'wts-eae' );
	}

	public function update_icon_control() {
		$this->update_control(
			'global_icon_view',
			[
				'default' => 'stacked',
			]
		);
		$this->update_control(
			'global_icon_shape',
			[
				'default' => 'circle',
			]
		);
	}
	public function extra_control() {
		$this->update_control(
			'timeline_align',
			[
				'default' => 'right',
			]
		);
		$this->update_control(
			'content_align',
			[
				'default' => 'right',
			]
		);
		$this->update_control(
			'background_color',
			[
				'default' => '#e4dafb',
			]
		);
		$this->update_control(
			'vertical_spacing',
			[
				'default' => [
					'size' => 10,
				],
			]
		);
		$this->update_control(
			'item_icon_icon_size',
			[
				'default' => [
					'size' => 20,
				],
			]
		);
		$this->update_control(
			'item_icon_icon_padding',
			[
				'default' => [
					'size' => 5,
				],
			]
		);
		$this->update_control(
			'item_icon_icon_focus_secondary_color',
			[
				'default' => '#fff',
			]
		);
		$this->update_control(
			'item_icon_icon_focus_primary_color',
			[
				'default' => '#23a455',
			]
		);
	}
	public function register_items_control( Widget_Base $widget ) {
		$this->parent = $widget;
	}
	public function register_style_controls() {
		parent::register_style_controls(); // TODO: Change the autogenerated stub
		$this->eae_timeline_style_section();
	}
	public function render() {
		$this->common_render();
	}
}
